/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader;

import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.reader.Messages;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public final class ExtensionBindingChecker
extends XMLFilterImpl {
    private final NamespaceSupport nsSupport = new NamespaceSupport();
    private int count = 0;
    private final Set<String> enabledExtensions = new HashSet<String>();
    private final Set<String> recognizableExtensions = new HashSet<String>();
    private Locator locator;
    private int cutDepth = 0;
    private static final ContentHandler stub = new DefaultHandler();
    private ContentHandler next;
    private final String schemaLanguage;
    private final boolean allowExtensions;
    private final Options options;

    public ExtensionBindingChecker(String schemaLanguage, Options options, ErrorHandler handler) {
        this.schemaLanguage = schemaLanguage;
        this.allowExtensions = options.compatibilityMode != 1;
        this.options = options;
        this.setErrorHandler(handler);
        for (Plugin plugin : options.getAllPlugins()) {
            this.recognizableExtensions.addAll(plugin.getCustomizationURIs());
        }
        this.recognizableExtensions.add("http://java.sun.com/xml/ns/jaxb/xjc");
    }

    private boolean isSupportedExtension(String namespaceUri) {
        if (namespaceUri.equals("http://java.sun.com/xml/ns/jaxb/xjc")) {
            return true;
        }
        return this.options.pluginURIs.contains(namespaceUri);
    }

    private boolean isRecognizableExtension(String namespaceUri) {
        return this.recognizableExtensions.contains(namespaceUri);
    }

    private boolean needsToBePruned(String uri) {
        if (uri.equals(this.schemaLanguage)) {
            return false;
        }
        if (uri.equals("http://java.sun.com/xml/ns/jaxb")) {
            return false;
        }
        if (this.enabledExtensions.contains(uri)) {
            return false;
        }
        return this.isRecognizableExtension(uri);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.count = 0;
        this.cutDepth = 0;
        this.nsSupport.reset();
        this.enabledExtensions.clear();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.nsSupport.pushContext();
        this.nsSupport.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        this.nsSupport.popContext();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.cutDepth == 0) {
            String v = atts.getValue("http://java.sun.com/xml/ns/jaxb", "extensionBindingPrefixes");
            if (v != null) {
                if (this.count != 0) {
                    this.error(Messages.ERR_UNEXPECTED_EXTENSION_BINDING_PREFIXES.format(new Object[0]));
                }
                if (!this.allowExtensions) {
                    this.error(Messages.ERR_VENDOR_EXTENSION_DISALLOWED_IN_STRICT_MODE.format(new Object[0]));
                }
                StringTokenizer tokens = new StringTokenizer(v);
                while (tokens.hasMoreTokens()) {
                    String prefix = tokens.nextToken();
                    String uri = this.nsSupport.getURI(prefix);
                    if (uri == null) {
                        this.error(Messages.ERR_UNDECLARED_PREFIX.format(prefix));
                        continue;
                    }
                    if (!this.isRecognizableExtension(uri)) {
                        this.error(Messages.ERR_UNSUPPORTED_EXTENSION.format(prefix));
                    } else if (!this.isSupportedExtension(uri)) {
                        Plugin owner = null;
                        for (Plugin p : this.options.getAllPlugins()) {
                            if (!p.getCustomizationURIs().contains(uri)) continue;
                            owner = p;
                            break;
                        }
                        if (owner != null) {
                            this.error(Messages.ERR_PLUGIN_NOT_ENABLED.format(owner.getOptionName(), uri));
                        } else {
                            this.error(Messages.ERR_UNSUPPORTED_EXTENSION.format(prefix));
                        }
                    }
                    this.enabledExtensions.add(uri);
                }
            }
            if (this.needsToBePruned(namespaceURI)) {
                if (this.isRecognizableExtension(namespaceURI)) {
                    this.warning(Messages.ERR_SUPPORTED_EXTENSION_IGNORED.format(namespaceURI));
                }
                super.setContentHandler(stub);
                this.cutDepth = 1;
            } else if (this.options.pluginURIs.contains(namespaceURI)) {
                boolean correct = false;
                for (Plugin p : this.options.activePlugins) {
                    if (!p.isCustomizationTagName(namespaceURI, localName)) continue;
                    correct = true;
                    break;
                }
                if (!correct) {
                    this.error(Messages.ERR_ILLEGAL_CUSTOMIZATION_TAGNAME.format(qName));
                    super.setContentHandler(stub);
                    this.cutDepth = 1;
                }
            }
        } else {
            ++this.cutDepth;
        }
        ++this.count;
        super.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        if (this.cutDepth != 0) {
            --this.cutDepth;
            if (this.cutDepth == 0) {
                super.setContentHandler(this.next);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public void setContentHandler(ContentHandler handler) {
        this.next = handler;
        if (this.getContentHandler() != stub) {
            super.setContentHandler(handler);
        }
    }

    private SAXParseException error(String msg) throws SAXException {
        SAXParseException spe = new SAXParseException(msg, this.locator);
        this.getErrorHandler().error(spe);
        return spe;
    }

    private void warning(String msg) throws SAXException {
        SAXParseException spe = new SAXParseException(msg, this.locator);
        this.getErrorHandler().warning(spe);
    }
}

